/****** Object:  StoredProcedure [dbo].[P_ADM_AUDIT]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ADM_AUDIT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ADM_AUDIT]
GO
GO
CREATE PROCEDURE [dbo].[P_ADM_AUDIT] (@ID INT)
AS
BEGIN
DECLARE @RS_RETORNO TABLE (
	ID INT,
	CAMPO VARCHAR(MAX),
	VALOR VARCHAR(MAX))
DECLARE @XML VARCHAR(MAX)
DECLARE @ID_XML INT
DECLARE @HOSTNAME nvarchar(512)
DECLARE @APPNAME nvarchar(512)
DECLARE @USERNAME nvarchar(512)
DECLARE @TABLENAME SYSNAME
DECLARE @DATA DATE
DECLARE @HORA DATETIME
DECLARE @ACAO VARCHAR(30)
DECLARE @COMMAND VARCHAR(MAX)
SELECT
	@XML = CONVERT(VARCHAR(MAX), EVENTO),
	@HOSTNAME = HOSTNAME,
	@APPNAME = APPNAME,
	@USERNAME = USERNAME,
	@TABLENAME = TABLENAME,
	@DATA = DATA,
	@HORA = HORA,
	@ACAO = ACAO,
	@COMMAND = COMMAND_TEXT
FROM
	ADM_TABLE_EVENT_AUDIT
WHERE
	ID = @ID
EXEC sp_xml_preparedocument @ID_XML OUTPUT, @XML
INSERT INTO 
	@RS_RETORNO
SELECT
	--@HOSTNAME AS HOSTNAME,
	--@APPNAME AS APPNAME,
	--@USERNAME AS USERNAME,
	--@TABLENAME AS TABLENAME,
	--@DATA AS DATA,
	--@HORA AS HORA,
	--@ACAO AS ACAO,
	--@COMMAND AS COMMAND_TEXT,
	@ID,
	D.LOCALNAME AS CAMPO,
	DD.TEXT AS VALOR
FROM
	OPENXML (@ID_XML, 'Audit/Dados', 1) D
	INNER JOIN OPENXML (@ID_XML, 'Audit/Dados', 1) DD ON
		D.ID = DD.PARENTID
WHERE
	DD.TEXT IS NOT NULL
SELECT * FROM @RS_RETORNO
RETURN
END

GO


